#ifndef GST_CU_CONSTRAINED_COLOR_DESC_HPP__
#define GST_CU_CONSTRAINED_COLOR_DESC_HPP__

#include "buildspec.h"

#include "Client/ClientUtils/Network/NetworkInterfaceStructs.h"
#include "Client/ClientUtils/Network/TableAttributeDesc.h"

namespace GST
{
namespace ClientUtils
{
class GST_API_EXPORT ConstrainedColorDescription : public TableAttributeDesc
{
public:
	ConstrainedColorDescription(
		const std::string &name,
		const std::string &tableName,
		const std::vector<ConstrainedColumnDescription> &columns,
		int colIndex = -1,
		int64_t id = -1);
	const std::vector<ConstrainedColumnDescription> &columns() const;
	TableAttributeDesc *clone() const override;

private:
	// The columns making up the constrained color
	std::vector<ConstrainedColumnDescription> m_columns;
};

} // namespace ClientUtils
} // namespace GST
#endif // GST_CU_CONSTRAINED_COLOR_DESC_HPP__
